class DepositMethodsModel {
  bool? status;
  List<DepositMethodsData>? data;

  DepositMethodsModel({this.status, this.data});

  DepositMethodsModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    if (json['data'] != null) {
      data = <DepositMethodsData>[];
      json['data'].forEach((v) {
        data!.add(DepositMethodsData.fromJson(v));
      });
    }
  }
}

class DepositMethodsData {
  int? id;
  int? gatewayId;
  String? logo;
  String? name;
  String? type;
  String? gatewayCode;
  int? charge;
  String? chargeType;
  int? minimumDeposit;
  int? maximumDeposit;
  double? rate;
  String? currency;
  String? currencySymbol;
  String? fieldOptions;
  String? paymentDetails;
  int? status;
  String? createdAt;
  String? updatedAt;
  String? gatewayLogo;

  DepositMethodsData({
    this.id,
    this.gatewayId,
    this.logo,
    this.name,
    this.type,
    this.gatewayCode,
    this.charge,
    this.chargeType,
    this.minimumDeposit,
    this.maximumDeposit,
    this.rate,
    this.currency,
    this.currencySymbol,
    this.fieldOptions,
    this.paymentDetails,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.gatewayLogo,
  });

  DepositMethodsData.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    gatewayId = json['gateway_id'];
    logo = json['logo'];
    name = json['name'];
    type = json['type'];
    gatewayCode = json['gateway_code'];
    charge = json['charge'];
    chargeType = json['charge_type'];
    minimumDeposit = json['minimum_deposit'];
    maximumDeposit = json['maximum_deposit'];
    rate = json['rate']?.toDouble();
    currency = json['currency'];
    currencySymbol = json['currency_symbol'];
    fieldOptions = json['field_options'];
    paymentDetails = json['payment_details'];
    status = json['status'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
    gatewayLogo = json['gateway_logo'];
  }
}
