class FdrPlanListModel {
  bool? status;
  List<FdrPlanListData>? data;
  Meta? meta;

  FdrPlanListModel({this.status, this.data, this.meta});

  FdrPlanListModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    if (json['data'] != null) {
      data = <FdrPlanListData>[];
      json['data'].forEach((v) {
        data!.add(FdrPlanListData.fromJson(v));
      });
    }
    meta = json['meta'] != null ? Meta.fromJson(json['meta']) : null;
  }
}

class FdrPlanListData {
  String? fdrName;
  String? fdrId;
  String? status;
  bool? isCancellable;
  String? createdAt;

  FdrPlanListData({
    this.fdrName,
    this.fdrId,
    this.status,
    this.isCancellable,
    this.createdAt,
  });

  FdrPlanListData.fromJson(Map<String, dynamic> json) {
    fdrName = json['fdr_name'];
    fdrId = json['fdr_id'];
    status = json['status'];
    isCancellable = json['is_cancellable'];
    createdAt = json['created_at'];
  }
}

class Meta {
  int? currentPage;
  int? lastPage;
  int? perPage;
  int? total;

  Meta({this.currentPage, this.lastPage, this.perPage, this.total});

  Meta.fromJson(Map<String, dynamic> json) {
    currentPage = json['current_page'];
    lastPage = json['last_page'];
    perPage = json['per_page'];
    total = json['total'];
  }
}
