class BeneficiaryModel {
  bool? status;
  List<BeneficiaryData>? data;

  BeneficiaryModel({this.status, this.data});

  BeneficiaryModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    if (json['data'] != null) {
      data = <BeneficiaryData>[];
      json['data'].forEach((v) {
        data!.add(BeneficiaryData.fromJson(v));
      });
    }
  }
}

class BeneficiaryData {
  int? id;
  int? bankId;
  int? userId;
  String? accountNumber;
  String? accountName;
  String? branchName;
  String? nickName;
  String? createdAt;
  String? updatedAt;

  BeneficiaryData({
    this.id,
    this.bankId,
    this.userId,
    this.accountNumber,
    this.accountName,
    this.branchName,
    this.nickName,
    this.createdAt,
    this.updatedAt,
  });

  BeneficiaryData.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    bankId = json['bank_id'];
    userId = json['user_id'];
    accountNumber = json['account_number'];
    accountName = json['account_name'];
    branchName = json['branch_name'];
    nickName = json['nick_name'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
  }
}
