import 'package:digi_bank/src/app/constants/app_colors.dart';
import 'package:digi_bank/src/common/controller/navigation/navigation_controller.dart';
import 'package:digi_bank/src/common/controller/theme/theme_controller.dart';
import 'package:digi_bank/src/common/widgets/common_no_data_found.dart';
import 'package:digi_bank/src/presentation/screens/all_transaction/view/all_transaction.dart';
import 'package:digi_bank/src/presentation/screens/home/controller/home_controller.dart';
import 'package:digi_bank/src/presentation/screens/home/model/dashboard_model.dart';
import 'package:digi_bank/src/presentation/screens/home/view/sub_sections/transaction_dialog.dart';
import 'package:digi_bank/src/presentation/widgets/transaction_dynamic_icon/transaction_dynamic_icon.dart';
import 'package:digi_bank/src/utils/extensions/translation_extension.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

class RecentTransactionSection extends StatelessWidget {
  const RecentTransactionSection({super.key});

  @override
  Widget build(BuildContext context) {
    final homeController = Get.find<HomeController>();
    final ThemeController themeController = Get.find<ThemeController>();

    return Container(
      margin: EdgeInsets.symmetric(horizontal: 16),
      width: double.infinity,
      child: Column(
        children: [
          _buildTransferList(themeController),
          SizedBox(height: 10),
          homeController.dashboardModel.value.data!.transactions!.isEmpty
              ? Center(
                child: CommonNoDataFound(
                  message: "home.recentTransactions.no_data".trns(),
                ),
              )
              : ListView.separated(
                physics: NeverScrollableScrollPhysics(),
                shrinkWrap: true,
                itemBuilder: (context, index) {
                  final Transactions transaction =
                      homeController
                          .dashboardModel
                          .value
                          .data!
                          .transactions![index];

                  return Obx(
                    () => InkWell(
                      borderRadius: BorderRadius.circular(30),
                      onTap: () {
                        showTransactionDialog(transaction);
                      },
                      child: Container(
                        padding: EdgeInsets.symmetric(
                          horizontal: 14,
                          vertical: 14,
                        ),
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(16),
                          color:
                              themeController.isDarkMode.value
                                  ? AppColors.darkSecondary
                                  : AppColors.white,
                          border: Border.all(
                            color:
                                themeController.isDarkMode.value
                                    ? AppColors.darkCardBorder
                                    : Color(0xFFE0E0E0).withValues(alpha: 0.5),
                          ),
                        ),
                        child: Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            Expanded(
                              child: Row(
                                children: [
                                  Container(
                                    width: 33,
                                    height: 33,
                                    decoration: BoxDecoration(
                                      borderRadius: BorderRadius.circular(100),
                                      color:
                                          themeController.isDarkMode.value
                                              ? AppColors.darkPrimary
                                                  .withValues(alpha: 0.10)
                                              : AppColors.primary.withValues(
                                                alpha: 0.10,
                                              ),
                                    ),
                                    child: Padding(
                                      padding: EdgeInsets.all(7.5),
                                      child: Image.asset(
                                        TransactionDynamicIcon.getTransactionIcon(
                                          transaction.type,
                                        ),
                                        color:
                                            themeController.isDarkMode.value
                                                ? AppColors.darkPrimary
                                                : AppColors.primary,
                                      ),
                                    ),
                                  ),
                                  SizedBox(width: 8),
                                  Expanded(
                                    child: Column(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: [
                                        Row(
                                          children: [
                                            Text(
                                              transaction.type!,
                                              style: TextStyle(
                                                fontWeight: FontWeight.w600,
                                                fontSize: 13,
                                                color:
                                                    themeController
                                                            .isDarkMode
                                                            .value
                                                        ? AppColors
                                                            .darkTextPrimary
                                                        : AppColors.textPrimary,
                                              ),
                                            ),
                                            SizedBox(width: 4),
                                            Container(
                                              padding: EdgeInsets.symmetric(
                                                horizontal: 10,
                                                vertical: 5,
                                              ),
                                              decoration: BoxDecoration(
                                                borderRadius:
                                                    BorderRadius.circular(22),
                                                color:
                                                    transaction.status ==
                                                            "Success"
                                                        ? AppColors.success
                                                            .withValues(
                                                              alpha: 0.10,
                                                            )
                                                        : transaction.status ==
                                                            "Pending"
                                                        ? AppColors.warning
                                                            .withValues(
                                                              alpha: 0.10,
                                                            )
                                                        : AppColors.error
                                                            .withValues(
                                                              alpha: 0.10,
                                                            ),
                                              ),
                                              child: Text(
                                                transaction.status!,
                                                style: TextStyle(
                                                  fontWeight: FontWeight.w600,
                                                  fontSize: 9,
                                                  color:
                                                      transaction.status ==
                                                              "Success"
                                                          ? AppColors.success
                                                          : transaction
                                                                  .status ==
                                                              "Pending"
                                                          ? AppColors.warning
                                                          : AppColors.error,
                                                ),
                                              ),
                                            ),
                                          ],
                                        ),
                                        SizedBox(height: 6),
                                        Column(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.start,
                                          children: [
                                            Text(
                                              transaction.tnx!,
                                              style: TextStyle(
                                                fontWeight: FontWeight.w500,
                                                fontSize: 10,
                                                color:
                                                    themeController
                                                            .isDarkMode
                                                            .value
                                                        ? AppColors
                                                            .darkTextTertiary
                                                        : AppColors.textPrimary,
                                              ),
                                            ),
                                            SizedBox(height: 2),
                                            Text(
                                              transaction.createdAt!,
                                              style: TextStyle(
                                                fontWeight: FontWeight.w400,
                                                fontSize: 10,
                                                color:
                                                    themeController
                                                            .isDarkMode
                                                            .value
                                                        ? AppColors
                                                            .darkTextPrimary
                                                            .withValues(
                                                              alpha: 0.60,
                                                            )
                                                        : AppColors.textPrimary
                                                            .withValues(
                                                              alpha: 0.60,
                                                            ),
                                              ),
                                            ),
                                          ],
                                        ),
                                      ],
                                    ),
                                  ),
                                ],
                              ),
                            ),
                            Text(
                              "${transaction.isPlus == true ? "+" : "-"}${transaction.amount}",
                              style: TextStyle(
                                fontWeight: FontWeight.w700,
                                fontSize: 14,
                                color:
                                    transaction.isPlus == true
                                        ? AppColors.success
                                        : AppColors.error,
                              ),
                            ),
                          ],
                        ),
                      ),
                    ),
                  );
                },
                separatorBuilder: (context, index) {
                  return SizedBox(height: 10);
                },
                itemCount:
                    homeController
                        .dashboardModel
                        .value
                        .data!
                        .transactions!
                        .length,
              ),
        ],
      ),
    );
  }

  void showTransactionDialog(Transactions transaction) {
    Get.dialog(TransactionDialog(controller: transaction));
  }

  Widget _buildTransferList(ThemeController themeController) {
    return Obx(
      () => Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          Text(
            "home.recentTransactions.title".trns(),
            style: TextStyle(
              fontWeight: FontWeight.w600,
              fontSize: 16,
              color:
                  themeController.isDarkMode.value
                      ? AppColors.darkTextPrimary
                      : AppColors.textPrimary,
            ),
          ),
          InkWell(
            onTap:
                () =>
                    Get.find<NavigationController>().pushPage(AllTransaction()),
            child: Text(
              "home.recentTransactions.see_all".trns(),
              style: TextStyle(
                fontWeight: FontWeight.w700,
                fontSize: 12,
                color:
                    themeController.isDarkMode.value
                        ? AppColors.darkPrimary
                        : AppColors.primary,
              ),
            ),
          ),
        ],
      ),
    );
  }
}
