class KycModel {
  bool? status;
  List<KycData>? data;

  KycModel({this.status, this.data});

  KycModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    if (json['data'] != null) {
      data = <KycData>[];
      json['data'].forEach((v) {
        data!.add(KycData.fromJson(v));
      });
    }
  }
}

class KycData {
  int? id;
  String? name;
  String? fields;
  int? status;
  String? createdAt;
  String? updatedAt;

  KycData({
    this.id,
    this.name,
    this.fields,
    this.status,
    this.createdAt,
    this.updatedAt,
  });

  KycData.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    fields = json['fields'];
    status = json['status'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
  }
}
