class DpsPlanListModel {
  bool? status;
  List<DpsPlanListData>? data;
  Meta? meta;

  DpsPlanListModel({this.status, this.data, this.meta});

  DpsPlanListModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    if (json['data'] != null) {
      data = <DpsPlanListData>[];
      json['data'].forEach((v) {
        data!.add(DpsPlanListData.fromJson(v));
      });
    }
    meta = json['meta'] != null ? Meta.fromJson(json['meta']) : null;
  }
}

class DpsPlanListData {
  String? dpsName;
  String? dpsId;
  String? status;
  bool? isCancellable;
  String? createdAt;

  DpsPlanListData({
    this.dpsName,
    this.dpsId,
    this.status,
    this.isCancellable,
    this.createdAt,
  });

  DpsPlanListData.fromJson(Map<String, dynamic> json) {
    dpsName = json['dps_name'];
    dpsId = json['dps_id'];
    status = json['status'];
    isCancellable = json["is_cancellable"];
    createdAt = json["created_at"];
  }
}

class Meta {
  int? currentPage;
  int? lastPage;
  int? perPage;
  int? total;

  Meta({this.currentPage, this.lastPage, this.perPage, this.total});

  Meta.fromJson(Map<String, dynamic> json) {
    currentPage = json['current_page'];
    lastPage = json['last_page'];
    perPage = json['per_page'];
    total = json['total'];
  }
}
