class FdrDetailsModel {
  bool? status;
  FdrDetailsData? data;

  FdrDetailsModel({this.status, this.data});

  FdrDetailsModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    data = json['data'] != null ? FdrDetailsData.fromJson(json['data']) : null;
  }
}

class FdrDetailsData {
  int? id;
  String? fdrId;
  String? fdrName;
  String? status;
  String? amount;
  String? profit;
  String? profitPeriod;
  String? totalReturns;
  String? givenReturns;
  String? totalProfit;
  String? nextReceiveDate;
  String? totalProfitAmount;
  bool? isIncrease;
  String? minIncreaseAmount;
  String? maxIncreaseAmount;
  bool? isDecrease;
  String? minDecreaseAmount;
  String? maxDecreaseAmount;

  FdrDetailsData({
    this.id,
    this.fdrId,
    this.fdrName,
    this.status,
    this.amount,
    this.profit,
    this.profitPeriod,
    this.totalReturns,
    this.givenReturns,
    this.totalProfit,
    this.nextReceiveDate,
    this.totalProfitAmount,
    this.isIncrease,
    this.minIncreaseAmount,
    this.maxIncreaseAmount,
    this.isDecrease,
    this.minDecreaseAmount,
    this.maxDecreaseAmount,
  });

  FdrDetailsData.fromJson(Map<String, dynamic> json) {
    id = json["id"];
    fdrId = json['fdr_id'];
    fdrName = json['fdr_name'];
    status = json['status'];
    amount = json['amount'];
    profit = json['profit'];
    profitPeriod = json['profit_period'];
    totalReturns = json['total_returns'];
    givenReturns = json['given_returns'];
    totalProfit = json['total_profit'];
    nextReceiveDate = json['next_receive_date'];
    totalProfitAmount = json['total_profit_amount'];
    isIncrease = json['is_increase'];
    minIncreaseAmount = json['min_increase_amount'];
    maxIncreaseAmount = json['max_increase_amount'];
    isDecrease = json['is_decrease'];
    minDecreaseAmount = json['min_decrease_amount'];
    maxDecreaseAmount = json['max_decrease_amount'];
  }
}
