import 'package:digi_bank/src/app/constants/app_colors.dart';
import 'package:digi_bank/src/app/constants/assets_path/png/png_assets.dart';
import 'package:digi_bank/src/app/constants/assets_path/svg/svg_assets.dart';
import 'package:digi_bank/src/app/routes/routes.dart';
import 'package:digi_bank/src/common/controller/theme/theme_controller.dart';
import 'package:digi_bank/src/common/widgets/common_alert_dialog.dart';
import 'package:digi_bank/src/common/widgets/common_elevated_button.dart';
import 'package:digi_bank/src/utils/extensions/translation_extension.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_svg/svg.dart';
import 'package:get/get.dart';

class WelcomeScreen extends StatefulWidget {
  const WelcomeScreen({super.key});

  @override
  State<WelcomeScreen> createState() => _WelcomeScreenState();
}

class _WelcomeScreenState extends State<WelcomeScreen> {
  final ThemeController themeController = Get.find<ThemeController>();

  @override
  Widget build(BuildContext context) {
    final title = "welcome.title".trns();
    final appName = "welcome.appName".trns();
    final tagline = "welcome.tagline".trns();
    final buttonText = "welcome.buttonText".trns();

    return PopScope(
      canPop: false,
      onPopInvokedWithResult: (_, __) {
        showExitApplicationAlertDialog();
      },
      child: Scaffold(
        appBar: AppBar(
          toolbarHeight: 0,
          backgroundColor:
              themeController.isDarkMode.value
                  ? AppColors.darkBackground
                  : AppColors.primary,
        ),
        body: ColoredBox(
          color:
              themeController.isDarkMode.value
                  ? AppColors.darkBackground
                  : AppColors.background,
          child: Stack(
            children: [
              Positioned(
                left: 0,
                bottom: 0,
                child: Image.asset(
                  PngAssets.welcomeShapeFive,
                  color:
                      themeController.isDarkMode.value
                          ? Color(0xFF1C2E24)
                          : Color(0xFFF2EAFF),
                ),
              ),
              Positioned(
                top: 0,
                right: 0,
                child: Image.asset(
                  themeController.isDarkMode.value
                      ? PngAssets.welcomeDarkShapeSix
                      : PngAssets.welcomeShapeSix,
                ),
              ),
              Column(
                children: [
                  Expanded(
                    child: Center(
                      child: Stack(
                        clipBehavior: Clip.none,
                        children: [
                          Image.asset(PngAssets.welcomeBanner, width: 220),
                          Positioned(
                            right: -60,
                            bottom: -60,
                            child: Image.asset(
                              themeController.isDarkMode.value
                                  ? PngAssets.welcomeDarkShapeOne
                                  : PngAssets.welcomeShapeOne,
                              color:
                                  themeController.isDarkMode.value
                                      ? AppColors.grey.withValues(alpha: 0.7)
                                      : null,
                            ),
                          ),
                          Positioned(
                            left: -50,
                            bottom: -40,
                            child: SvgPicture.asset(
                              SvgAssets.welcomeShapeThree,
                              colorFilter: ColorFilter.mode(
                                Color(0xFF0890FE).withValues(alpha: 0.08),
                                BlendMode.srcIn,
                              ),
                            ),
                          ),
                          Positioned(
                            right: -55,
                            bottom: 20,
                            child: SvgPicture.asset(
                              SvgAssets.welcomeShapeTwo,
                              colorFilter: ColorFilter.mode(
                                Color(0xFFFF4267).withValues(alpha: 0.1),
                                BlendMode.srcIn,
                              ),
                            ),
                          ),
                          Positioned(
                            left: -70,
                            bottom: 50,
                            child: Image.asset(
                              themeController.isDarkMode.value
                                  ? PngAssets.welcomeDarkShapeOne
                                  : PngAssets.welcomeShapeOne,
                              color:
                                  themeController.isDarkMode.value
                                      ? AppColors.grey.withValues(alpha: 0.7)
                                      : null,
                            ),
                          ),
                        ],
                      ),
                    ),
                  ),
                  Stack(
                    clipBehavior: Clip.none,
                    children: [
                      Text(
                        title,
                        style: TextStyle(
                          fontSize: 24,
                          fontWeight: FontWeight.w500,
                          color:
                              themeController.isDarkMode.value
                                  ? AppColors.darkTextPrimary.withValues(
                                    alpha: 0.80,
                                  )
                                  : AppColors.textPrimary.withValues(
                                    alpha: 0.90,
                                  ),
                        ),
                      ),
                      Positioned(
                        left: -33,
                        bottom: 3,
                        child: SvgPicture.asset(
                          SvgAssets.welcomeShapeFour,
                          colorFilter: ColorFilter.mode(
                            Color(0xFFFFAF2A).withValues(alpha: 0.1),
                            BlendMode.srcIn,
                          ),
                        ),
                      ),
                      Positioned(
                        right: -60,
                        top: 3,
                        child: SvgPicture.asset(
                          SvgAssets.welcomeShapeThree,
                          colorFilter: ColorFilter.mode(
                            Color(0xFF0890FE).withValues(alpha: 0.1),
                            BlendMode.srcIn,
                          ),
                        ),
                      ),
                    ],
                  ),
                  SizedBox(height: 4),
                  Text(
                    appName,
                    style: TextStyle(
                      fontFamily: "Qanelas Soft",
                      fontSize: 40,
                      fontWeight: FontWeight.w700,
                      color:
                          themeController.isDarkMode.value
                              ? AppColors.darkPrimary
                              : AppColors.primary,
                    ),
                  ),
                  SizedBox(height: 16),
                  Padding(
                    padding: EdgeInsets.symmetric(horizontal: 50),
                    child: Text(
                      tagline,
                      textAlign: TextAlign.center,
                      style: TextStyle(
                        fontWeight: FontWeight.w400,
                        fontSize: 16,
                        color:
                            themeController.isDarkMode.value
                                ? AppColors.darkTextTertiary
                                : AppColors.textTertiary,
                      ),
                    ),
                  ),
                  SizedBox(height: 40),
                  CommonElevatedButton(
                    buttonName: buttonText,
                    onPressed: () => Get.toNamed(BaseRoute.onboarding),
                    width: 200,
                    fontSize: 16,
                    fontFamily: "Inter",
                  ),
                  SizedBox(height: 90),
                ],
              ),
            ],
          ),
        ),
      ),
    );
  }

  void showExitApplicationAlertDialog() {
    final title = "welcome.exitDialog.title".trns();
    final message = "welcome.exitDialog.message".trns();
    Get.dialog(
      CommonAlertDialog(
        title: title,
        message: message,
        onConfirm: () => SystemNavigator.pop(),
        onCancel: () => Get.back(),
      ),
    );
  }
}
