import 'package:digi_bank/src/app/bindings/initial_binding.dart';
import 'package:digi_bank/src/app/config/theme/dark_theme.dart';
import 'package:digi_bank/src/app/config/theme/light_theme.dart';
import 'package:digi_bank/src/app/constants/app_strings.dart';
import 'package:digi_bank/src/app/routes/routes.dart';
import 'package:digi_bank/src/app/routes/routes_handler.dart';
import 'package:digi_bank/src/common/controller/theme/theme_controller.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

class DigiBank extends StatelessWidget {
  const DigiBank({super.key});

  @override
  Widget build(BuildContext context) {
    final ThemeController themeController = Get.find<ThemeController>();

    return Obx(
      () => GetMaterialApp(
        initialBinding: InitialBinding(),
        debugShowCheckedModeBanner: false,
        title: AppStrings.appName,
        defaultTransition: Transition.fade,
        transitionDuration: const Duration(milliseconds: 300),
        themeMode:
            themeController.isDarkMode.value ? ThemeMode.dark : ThemeMode.light,
        theme: LightTheme().lightTheme(context),
        darkTheme: DarkTheme().darkTheme(context),
        getPages: routesHandler,
        initialRoute: BaseRoute.splash,
      ),
    );
  }
}
