class UserModel {
  int? id;
  int? portfolioId;
  int? branchId;
  String? portfolios;
  String? avatar;
  String? firstName;
  String? lastName;
  String? country;
  String? phone;
  String? username;
  String? email;
  String? gender;
  String? dateOfBirth;
  String? city;
  String? zipCode;
  String? address;
  double? balance;
  int? points;
  int? status;
  String? closeReason;
  int? refId;
  String? accountNumber;
  int? kyc;
  String? kycCredential;
  bool? twoFa;
  int? depositStatus;
  int? withdrawStatus;
  int? transferStatus;
  int? otpStatus;
  int? dpsStatus;
  int? fdrStatus;
  int? loanStatus;
  int? payBillStatus;
  int? portfolioStatus;
  int? rewardStatus;
  int? referralStatus;
  String? emailVerifiedAt;
  NotificationsPermission? notificationsPermission;
  String? passcode;
  bool? phoneVerified;
  String? otp;
  String? createdAt;
  String? updatedAt;
  String? deletedAt;
  String? fullName;
  String? kycTime;
  String? kycType;
  String? totalProfit;
  String? totalDeposit;
  String? avatarPath;
  bool? twoFaIntitialized;
  bool? isUnreadNotification;
  String? twoFaQrCode;

  UserModel({
    this.id,
    this.portfolioId,
    this.branchId,
    this.portfolios,
    this.avatar,
    this.firstName,
    this.lastName,
    this.country,
    this.phone,
    this.username,
    this.email,
    this.gender,
    this.dateOfBirth,
    this.city,
    this.zipCode,
    this.address,
    dynamic balance,
    this.points,
    this.status,
    this.closeReason,
    this.refId,
    this.accountNumber,
    this.kyc,
    this.kycCredential,
    this.twoFa,
    this.depositStatus,
    this.withdrawStatus,
    this.transferStatus,
    this.otpStatus,
    this.dpsStatus,
    this.fdrStatus,
    this.loanStatus,
    this.payBillStatus,
    this.portfolioStatus,
    this.rewardStatus,
    this.referralStatus,
    this.emailVerifiedAt,
    this.notificationsPermission,
    this.passcode,
    this.phoneVerified,
    this.otp,
    this.createdAt,
    this.updatedAt,
    this.deletedAt,
    this.fullName,
    this.kycTime,
    this.kycType,
    this.totalProfit,
    this.totalDeposit,
    this.avatarPath,
    this.twoFaIntitialized,
    this.isUnreadNotification,
    this.twoFaQrCode,
  }) : balance = balance != null ? double.tryParse(balance.toString()) : null;

  factory UserModel.fromJson(Map<String, dynamic> json) {
    return UserModel(
      id: json['id'],
      portfolioId: json['portfolio_id'],
      branchId: json['branch_id'],
      portfolios: json['portfolios'],
      avatar: json['avatar'],
      firstName: json['first_name'],
      lastName: json['last_name'],
      country: json['country'],
      phone: json['phone'],
      username: json['username'],
      email: json['email'],
      gender: json['gender'],
      dateOfBirth: json['date_of_birth'],
      city: json['city'],
      zipCode: json['zip_code'],
      address: json['address'],
      balance: json['balance'],
      points: json['points'],
      status: json['status'],
      closeReason: json['close_reason'],
      refId: json['ref_id'],
      accountNumber: json['account_number'],
      kyc: json['kyc'],
      kycCredential: json['kyc_credential'],
      twoFa: json['two_fa'],
      depositStatus: json['deposit_status'],
      withdrawStatus: json['withdraw_status'],
      transferStatus: json['transfer_status'],
      otpStatus: json['otp_status'],
      dpsStatus: json['dps_status'],
      fdrStatus: json['fdr_status'],
      loanStatus: json['loan_status'],
      payBillStatus: json['pay_bill_status'],
      portfolioStatus: json['portfolio_status'],
      rewardStatus: json['reward_status'],
      referralStatus: json['referral_status'],
      emailVerifiedAt: json['email_verified_at'],
      notificationsPermission:
          json['notifications_permission'] != null
              ? NotificationsPermission.fromJson(
                json['notifications_permission'],
              )
              : null,
      passcode: json['passcode'],
      phoneVerified: json['phone_verified'],
      otp: json['otp'],
      createdAt: json['created_at'],
      updatedAt: json['updated_at'],
      deletedAt: json['deleted_at'],
      fullName: json['full_name'],
      kycTime: json['kyc_time'],
      kycType: json['kyc_type'],
      totalProfit: json['total_profit'],
      totalDeposit: json['total_deposit'],
      avatarPath: json['avatar_path'],
      twoFaIntitialized: json['2fa_intitialized'],
      isUnreadNotification: json['is_unread_notification'],
      twoFaQrCode: json['2fa_qr_code'],
    );
  }
}

class NotificationsPermission {
  bool? b2faNotifications;
  bool? allPushNotifications;
  bool? dpsEmailNotificaitons;
  bool? fdrEmailNotificaitons;
  bool? loanEmailNotificaitons;
  bool? depositEmailNotificaitons;
  bool? supportEmailNotificaitons;
  bool? payBillEmailNotificaitons;
  bool? referralEmailNotificaitons;
  bool? portfolioEmailNotificaitons;
  bool? fundTransferEmailNotificaitons;
  bool? rewardsRedeemEmailNotificaitons;
  bool? withdrawPaymentEmailNotificaitons;

  NotificationsPermission({
    this.b2faNotifications,
    this.allPushNotifications,
    this.dpsEmailNotificaitons,
    this.fdrEmailNotificaitons,
    this.loanEmailNotificaitons,
    this.depositEmailNotificaitons,
    this.supportEmailNotificaitons,
    this.payBillEmailNotificaitons,
    this.referralEmailNotificaitons,
    this.portfolioEmailNotificaitons,
    this.fundTransferEmailNotificaitons,
    this.rewardsRedeemEmailNotificaitons,
    this.withdrawPaymentEmailNotificaitons,
  });

  factory NotificationsPermission.fromJson(Map<String, dynamic> json) {
    return NotificationsPermission(
      b2faNotifications: json['2fa_notifications'],
      allPushNotifications: json['all_push_notifications'],
      dpsEmailNotificaitons: json['dps_email_notificaitons'],
      fdrEmailNotificaitons: json['fdr_email_notificaitons'],
      loanEmailNotificaitons: json['loan_email_notificaitons'],
      depositEmailNotificaitons: json['deposit_email_notificaitons'],
      supportEmailNotificaitons: json['support_email_notificaitons'],
      payBillEmailNotificaitons: json['pay_bill_email_notificaitons'],
      referralEmailNotificaitons: json['referral_email_notificaitons'],
      portfolioEmailNotificaitons: json['portfolio_email_notificaitons'],
      fundTransferEmailNotificaitons: json['fund_transfer_email_notificaitons'],
      rewardsRedeemEmailNotificaitons:
          json['rewards_redeem_email_notificaitons'],
      withdrawPaymentEmailNotificaitons:
          json['withdraw_payment_email_notificaitons'],
    );
  }
}
