class NavigationsModel {
  bool? status;
  List<NavigationsData>? data;

  NavigationsModel({this.status, this.data});

  NavigationsModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    if (json['data'] != null) {
      data = <NavigationsData>[];
      json['data'].forEach((v) {
        data!.add(NavigationsData.fromJson(v));
      });
    }
  }
}

class NavigationsData {
  String? name;
  String? type;
  int? priority;

  NavigationsData({this.name, this.type, this.priority});

  NavigationsData.fromJson(Map<String, dynamic> json) {
    name = json['name'];
    type = json['type'];
    priority = json['priority'];
  }
}
