class WalletsModel {
  bool? status;
  List<WalletsData>? data;

  WalletsModel({this.status, this.data});

  WalletsModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    if (json['data'] != null) {
      data = <WalletsData>[];
      json['data'].forEach((v) {
        data!.add(WalletsData.fromJson(v));
      });
    }
  }
}

class WalletsData {
  int? id;
  String? name;
  String? accountNo;
  String? balance;
  String? code;
  String? symbol;

  WalletsData({
    this.id,
    this.name,
    this.accountNo,
    this.balance,
    this.code,
    this.symbol,
  });

  WalletsData.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    accountNo = json['account_no'];
    balance = json['balance'];
    code = json['code'];
    symbol = json['symbol'];
  }
}
