class CurrenciesModel {
  bool? status;
  List<CurrenciesData>? data;

  CurrenciesModel({this.status, this.data});

  CurrenciesModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    if (json['data'] != null) {
      data = <CurrenciesData>[];
      json['data'].forEach((v) {
        data!.add(CurrenciesData.fromJson(v));
      });
    }
  }
}

class CurrenciesData {
  int? id;
  String? name;
  String? code;
  String? symbol;
  double? rate;
  String? createdAt;
  String? updatedAt;

  CurrenciesData({
    this.id,
    this.name,
    this.code,
    this.symbol,
    this.rate,
    this.createdAt,
    this.updatedAt,
  });

  CurrenciesData.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    code = json['code'];
    symbol = json['symbol'];
    rate = json['rate']?.toDouble();
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
  }
}
