class DpsPlanModel {
  bool? status;
  List<DpsPlanData>? data;

  DpsPlanModel({this.status, this.data});

  DpsPlanModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    if (json['data'] != null) {
      data = <DpsPlanData>[];
      json['data'].forEach((v) {
        data!.add(DpsPlanData.fromJson(v));
      });
    }
  }
}

class DpsPlanData {
  int? id;
  String? dpsName;
  int? perInstallment;
  String? installmentDays;
  String? totalInstallment;
  String? interestRate;
  String? totalDeposit;
  String? totalMatureAmount;
  String? maturityFee;
  String? cancelIn;
  String? cancelFee;
  int? isIncrease;
  String? increaseLimit;
  String? minIncreaseAmount;
  String? maxIncreaseAmount;
  String? increaseCharge;
  int? isDecrease;
  String? decreaseLimit;
  String? minDecreaseAmount;
  String? maxDecreaseAmount;
  String? decreaseCharge;
  String? badge;

  DpsPlanData({
    this.id,
    this.dpsName,
    this.perInstallment,
    this.installmentDays,
    this.totalInstallment,
    this.interestRate,
    this.totalDeposit,
    this.totalMatureAmount,
    this.maturityFee,
    this.cancelIn,
    this.cancelFee,
    this.isIncrease,
    this.increaseLimit,
    this.minIncreaseAmount,
    this.maxIncreaseAmount,
    this.increaseCharge,
    this.isDecrease,
    this.decreaseLimit,
    this.minDecreaseAmount,
    this.maxDecreaseAmount,
    this.decreaseCharge,
    this.badge,
  });

  DpsPlanData.fromJson(Map<String, dynamic> json) {
    id = json["id"];
    dpsName = json['dps_name'];
    perInstallment = json['per_installment'];
    installmentDays = json['installment_days'];
    totalInstallment = json['total_installment'];
    interestRate = json['interest_rate'];
    totalDeposit = json['total_deposit'];
    totalMatureAmount = json['total_mature_amount'];
    maturityFee = json['maturity_fee'];
    cancelIn = json['cancel_in'];
    cancelFee = json['cancel_fee'];
    isIncrease = json['is_increase'];
    increaseLimit = json['increase_limit'];
    minIncreaseAmount = json['min_increase_amount'];
    maxIncreaseAmount = json['max_increase_amount'];
    increaseCharge = json['increase_charge'];
    isDecrease = json['is_decrease'];
    decreaseLimit = json['decrease_limit'];
    minDecreaseAmount = json['min_decrease_amount'];
    maxDecreaseAmount = json['max_decrease_amount'];
    decreaseCharge = json['decrease_charge'];
    badge = json['badge'];
  }
}
