class LoanPlanModel {
  bool? status;
  List<LoanPlanData>? data;

  LoanPlanModel({this.status, this.data});

  LoanPlanModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    if (json['data'] != null) {
      data = <LoanPlanData>[];
      json['data'].forEach((v) {
        data!.add(LoanPlanData.fromJson(v));
      });
    }
  }
}

class LoanPlanData {
  int? id;
  String? name;
  String? minimumAmount;
  String? maximumAmount;
  String? installmentRate;
  String? installmentIntervel;
  String? totalInstallment;
  String? loanFee;
  String? fields;
  String? instructions;
  PlanData? planData;

  LoanPlanData({
    this.id,
    this.name,
    this.minimumAmount,
    this.maximumAmount,
    this.installmentRate,
    this.installmentIntervel,
    this.totalInstallment,
    this.loanFee,
    this.fields,
    this.instructions,
    this.planData,
  });

  LoanPlanData.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    minimumAmount = json['minimum_amount'];
    maximumAmount = json['maximum_amount'];
    installmentRate = json['installment_rate'];
    installmentIntervel = json['installment_intervel'];
    totalInstallment = json['total_installment'];
    loanFee = json['loan_fee'];
    fields = json['fields'];
    instructions = json['instructions'];
    planData =
        json['plan_data'] != null ? PlanData.fromJson(json['plan_data']) : null;
  }
}

class PlanData {
  int? interestRate;
  int? totalInstallment;
  int? loanFee;

  PlanData({this.interestRate, this.totalInstallment, this.loanFee});

  PlanData.fromJson(Map<String, dynamic> json) {
    interestRate = json['interest_rate'];
    totalInstallment = json['total_installment'];
    loanFee = json['loan_fee'];
  }
}
