class KycHistoryModel {
  bool? status;
  List<KycHistoryData>? data;

  KycHistoryModel({this.status, this.data});

  KycHistoryModel.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    if (json['data'] != null) {
      data = <KycHistoryData>[];
      json['data'].forEach((v) {
        data!.add(KycHistoryData.fromJson(v));
      });
    }
  }
}

class KycHistoryData {
  int? id;
  int? userId;
  int? kycId;
  String? type;
  Map<String, dynamic>? data;
  String? message;
  int? isValid;
  String? status;
  String? createdAt;
  String? updatedAt;

  KycHistoryData({
    this.id,
    this.userId,
    this.kycId,
    this.type,
    this.data,
    this.message,
    this.isValid,
    this.status,
    this.createdAt,
    this.updatedAt,
  });

  KycHistoryData.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    userId = json['user_id'];
    kycId = json['kyc_id'];
    type = json['type'];
    data = json['data'];
    message = json['message'];
    isValid = json['is_valid'];
    status = json['status'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
  }
}
